/*
 * Decompiled with CFR 0.152.
 */
class SquareWaveGenerator {
    public static final int CHAN_LEFT = 1;
    public static final int CHAN_RIGHT = 2;
    public static final int CHAN_MONO = 4;
    int totalLength;
    int cyclePos;
    int cycleLength;
    int amplitude;
    int dutyCycle;
    int channel;
    int sampleRate;
    int initialEnvelope;
    int numStepsEnvelope;
    boolean increaseEnvelope;
    int counterEnvelope;
    int gbFrequency;
    int timeSweep;
    int numSweep;
    boolean decreaseSweep;
    int counterSweep;

    public SquareWaveGenerator(int n, int n2, int n3, int n4, int n5) {
        this.cycleLength = n;
        this.amplitude = n2;
        this.cyclePos = 0;
        this.dutyCycle = n3;
        this.channel = n4;
        this.sampleRate = n5;
    }

    public SquareWaveGenerator(int n) {
        this.dutyCycle = 4;
        this.cyclePos = 0;
        this.channel = 3;
        this.cycleLength = 2;
        this.totalLength = 0;
        this.sampleRate = n;
        this.amplitude = 32;
        this.counterSweep = 0;
    }

    public void setSampleRate(int n) {
        this.sampleRate = n;
    }

    public void setDutyCycle(int n) {
        switch (n) {
            case 0: {
                this.dutyCycle = 1;
                break;
            }
            case 1: {
                this.dutyCycle = 2;
                break;
            }
            case 2: {
                this.dutyCycle = 4;
                break;
            }
            case 3: {
                this.dutyCycle = 6;
            }
        }
    }

    public void setFrequency(int n) {
        try {
            float f = 64.0f;
            if (n != 2048) {
                f = 131072.0f / (float)(2048 - n);
            }
            this.gbFrequency = n;
            this.cycleLength = f != 0.0f ? 256 * this.sampleRate / (int)f : 65535;
            if (this.cycleLength == 0) {
                this.cycleLength = 1;
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    public void setChannel(int n) {
        this.channel = n;
    }

    public void setEnvelope(int n, int n2, boolean bl) {
        this.initialEnvelope = n;
        this.numStepsEnvelope = n2;
        this.increaseEnvelope = bl;
        this.amplitude = n * 2;
    }

    public void setSweep(int n, int n2, boolean bl) {
        this.timeSweep = (n + 1) / 2;
        this.numSweep = n2;
        this.decreaseSweep = bl;
        this.counterSweep = 0;
    }

    public int getLength() {
        return this.totalLength;
    }

    public void setLength(int n) {
        this.totalLength = n == -1 ? -1 : (64 - n) / 4;
    }

    public void setLength3(int n) {
        this.totalLength = n == -1 ? -1 : (256 - n) / 4;
    }

    public void setVolume3(int n) {
        switch (n) {
            case 0: {
                this.amplitude = 0;
                break;
            }
            case 1: {
                this.amplitude = 32;
                break;
            }
            case 2: {
                this.amplitude = 16;
                break;
            }
            case 3: {
                this.amplitude = 8;
            }
        }
    }

    public void play(byte[] byArray, int n, int n2) {
        int n3 = 0;
        if (this.totalLength != 0) {
            --this.totalLength;
            if (this.timeSweep != 0) {
                ++this.counterSweep;
                if (this.counterSweep > this.timeSweep) {
                    if (this.decreaseSweep) {
                        this.setFrequency(this.gbFrequency - (this.gbFrequency >> this.numSweep));
                    } else {
                        this.setFrequency(this.gbFrequency + (this.gbFrequency >> this.numSweep));
                    }
                    this.counterSweep = 0;
                }
            }
            ++this.counterEnvelope;
            if (this.numStepsEnvelope != 0 && this.counterEnvelope % this.numStepsEnvelope == 0 && this.amplitude > 0) {
                if (!this.increaseEnvelope) {
                    if (this.amplitude > 0) {
                        this.amplitude -= 2;
                    }
                } else if (this.amplitude < 16) {
                    this.amplitude += 2;
                }
            }
            for (int i = n2; i < n2 + n; ++i) {
                if (this.cycleLength != 0) {
                    n3 = 8 * this.cyclePos / this.cycleLength >= this.dutyCycle ? this.amplitude : -this.amplitude;
                }
                if ((this.channel & 1) != 0) {
                    int n4 = i * 2;
                    byArray[n4] = (byte)(byArray[n4] + n3);
                }
                if ((this.channel & 2) != 0) {
                    int n5 = i * 2 + 1;
                    byArray[n5] = (byte)(byArray[n5] + n3);
                }
                if ((this.channel & 4) != 0) {
                    int n6 = i;
                    byArray[n6] = (byte)(byArray[n6] + n3);
                }
                this.cyclePos = (this.cyclePos + 256) % this.cycleLength;
            }
        }
    }
}

